/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CompositeSourceViewerConfiguration;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.contentassist.ContentAssistant;
import com.aptana.editor.common.spelling.MultiRegionSpellingReconcileStrategy;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.common.text.reconciler.CommonReconciler;
import com.aptana.editor.common.text.reconciler.CompositeReconcilingStrategy;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.php.core.PHPDoubleClickStrategy;
import com.aptana.editor.php.internal.text.reconciler.PHPReconcilingStrategy;
import com.aptana.editor.php.internal.ui.editor.PHPPartitionerSwitchStrategy;
import com.aptana.editor.php.internal.ui.editor.PHPSourceConfiguration;
import com.aptana.editor.php.internal.ui.editor.formatting.PHPAutoIndentStrategy;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class PHPSourceViewerConfiguration
extends CompositeSourceViewerConfiguration {
    private PHPDoubleClickStrategy fDoubleClickStrategy;

    public PHPSourceViewerConfiguration(IPreferenceStore preferences, AbstractThemeableEditor editor) {
        super((ISourceViewerConfiguration)HTMLSourceConfiguration.getDefault(), (ISourceViewerConfiguration)PHPSourceConfiguration.getDefault(), preferences, editor);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new PHPDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    protected IPartitionerSwitchStrategy getPartitionerSwitchStrategy() {
        return PHPPartitionerSwitchStrategy.getDefault();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = (PresentationReconciler)super.getPresentationReconciler(sourceViewer);
        PHPSourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        return reconciler;
    }

    protected String getStartEndTokenType() {
        return "";
    }

    protected String getTopContentType() {
        return "com.aptana.contenttype.phtml.php";
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.startsWith("__php_")) {
            return new IAutoEditStrategy[]{new PHPAutoIndentStrategy(contentType, this, sourceViewer)};
        }
        return new IAutoEditStrategy[]{new RubyRegexpAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, HTMLPlugin.getDefault().getPreferenceStore())};
    }

    protected IContentAssistProcessor getContentAssistProcessor(ISourceViewer sourceViewer, String contentType) {
        if (this.getEditor() == null) {
            return null;
        }
        return PHPSourceConfiguration.getDefault().getContentAssistProcessor(this.getEditor(), contentType);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant assistant = super.getContentAssistant(sourceViewer);
        if (assistant instanceof ContentAssistant) {
            ContentAssistant contentAssistant = (ContentAssistant)assistant;
            contentAssistant.enableAutoInsert(true);
        }
        return assistant;
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("com.aptana.editor.php", this.getEditor());
        return targets;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        AbstractThemeableEditor editor = this.getEditor();
        if (editor != null && editor.isEditable()) {
            PHPReconcilingStrategy reconcilingStrategy = new PHPReconcilingStrategy(editor);
            if (EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
                SpellingService spellingService = EditorsUI.getSpellingService();
                Collection spellingContentTypes = this.getSpellingContentTypes(sourceViewer);
                if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) != null && !spellingContentTypes.isEmpty()) {
                    reconcilingStrategy = new CompositeReconcilingStrategy(new IReconcilingStrategy[]{reconcilingStrategy, new MultiRegionSpellingReconcileStrategy(sourceViewer, spellingService, this.getConfiguredDocumentPartitioning(sourceViewer), spellingContentTypes)});
                }
            }
            CommonReconciler reconciler = new CommonReconciler((IReconcilingStrategy)reconcilingStrategy);
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setIsAllowedToModifyDocument(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            this.fReconciler = reconciler;
            return this.fReconciler;
        }
        return null;
    }
}

